<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/


/**
 *
 * @package XenCentral_AdServer
 */
class XenCentral_AdServer_DataWriter_Zone extends XenCentral_AdServer_DataWriter_Abstract
{
    /**
     * Gets the fields that are defined for the table. See parent for explanation.
     *
     * @return array
     */
    protected function _getFields()
    {
        return array(
            'xcas_zone' => array(
                'zoneId' => array(
                    'type' => self::TYPE_UINT,
                    'autoIncrement' => true
                ),
                'title' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true,
                    'minLength' => 0
                ),
                'locations' => array(
                    'type' => self::TYPE_SERIALIZED,
                    'required' => false,
                    'default' => 'a:0:{}'
                ),
                'width' => array(
                    'type' => self::TYPE_UINT,
                    'required' => false
                ),
                'height' => array(
                    'type' => self::TYPE_UINT,
                    'required' => false
                ),
                'force_dimensions' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'required' => false
                ),
                'use_placeholder' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'required' => false
                ),
                'rotate' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'required' => false
                ),
                'rotate_zone' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'required' => false
                ),
                'randomize_banners' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'required' => false
                ),
                'user_zone' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'required' => false
                ),
                'auto_rotate' => array(
                    'type' => self::TYPE_UINT,
                    'required' => false
                ),
                'slot_count' => array(
                    'type' => self::TYPE_UINT,
                    'required' => false
                ),
                'packages' => array(
                    'type' => self::TYPE_SERIALIZED,
                    'required' => false
                ),
                'page_criteria' => array(
                    'type' => self::TYPE_UNKNOWN,
                    'required' => false,
                    'verification' => array('$this', '_verifyCriteria'),
                    'default' => 'a:0:{}'
                ),
                'user_criteria' => array(
                    'type' => self::TYPE_UNKNOWN,
                    'required' => false,
                    'verification' => array('$this', '_verifyCriteria'),
                    'default' => 'a:0:{}'
                ),
                'page_criteria_not' => array(
                    'type' => self::TYPE_UNKNOWN,
                    'required' => false,
                    'verification' => array('$this', '_verifyCriteria'),
                    'default' => 'a:0:{}'
                ),
                'user_criteria_not' => array(
                    'type' => self::TYPE_UNKNOWN,
                    'required' => false,
                    'verification' => array('$this', '_verifyCriteria'),
                    'default' => 'a:0:{}'
                ),
                'display_order' => array(
                    'type' => self::TYPE_UINT,
                    'required' => false
                ),
                'active' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'required' => false
                ),
                'owners' => array(
                    'type' => self::TYPE_STRING,
                    'required' => false
                ),
                'creator_user_id' => array(
                    'type' => self::TYPE_UINT,
                    'required' => false
                ),
                'price_per_click' => array(
                    'type' => self::TYPE_FLOAT,
                    'required' => false
                ),
                'last_update' => array(
                    'type' => self::TYPE_UINT,
                    'required' => false
                ),

            )
        );
    }

    /**
     * Gets the actual existing data out of data that was passed in. See parent for explanation.
     *
     * @param mixed
     *
     * @return array|false
     */
    protected function _getExistingData($data)
    {
        if (!$id = $this->_getExistingPrimaryKey($data)) {
            return false;
        }

        return array(
            'xcas_zone' => $this->_getZoneModel()->getZoneById($id)
        );
    }

    protected function _getUpdateCondition($tableName)
    {
        return 'zoneId = ' . $this->_db->quote($this->getExisting('zoneId'));
    }

    protected function _verifyCriteria(&$criteria)
    {
        if(empty($criteria)) {
            $criteria=array();
        }

        $criteriaFiltered = XenForo_Helper_Criteria::prepareCriteriaForSave($criteria);
        $criteria = serialize($criteriaFiltered);
        return true;
    }

    protected function _preSave()
    {

    }

    protected function _preSaveDefaults()
    {
        parent::_preSaveDefaults();

        if ($this->getOption('owners') !== null) {
            $user_list = array();
            $users = array_map('trim', explode(',', $this->getOption('owners')));


            foreach($users AS $userid) {
                if($userid) {
                    $user = $this->_getUserModel()->getUserByName($userid);
                    if ($user) {
                        $user_list[] = $user['user_id'];
                    }
                }
            }


            $user_separated = rtrim(implode(",", $user_list), ',');
            $this->set('owners', $user_separated);
        }

        if(!$this->getNew('last_update')) {
            $this->set('last_update', time());
        }
    }

    protected function _postDelete()
    {
        parent::_postDelete();

        // delete impressions and clicks
        $this->_db->delete('xcas_impressions_zone', array(
            'zoneId='. $this->get('zoneId')
        ));
        $this->_db->delete('xcas_clicks_zone', array(
            'zoneId='.$this->get('zoneId')
        ));
    }


    protected function _postSave()
    {

    }

    protected function _getDefaultOptions()
    {
        return array(
            'owners'=>null
        );
    }
}